﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;

namespace WindowsGame1
{
    public class Sprite
    {
        public Texture2D tekstura;
        public Vector2 polozenie;
        public Vector2 rozmiar;
        public Vector2 predkosc;
        public Rectangle obszarRuchu;
        public Rectangle ObszarOgraniczajacy
        {
            get
            {
                return new Rectangle((int)polozenie.X, (int)polozenie.Y, (int)rozmiar.X, (int)rozmiar.Y);
            }
        }

        public Sprite(Texture2D tekstura, Vector2 polozenie, Vector2 rozmiar)
        {
            this.tekstura = tekstura;
            this.polozenie = polozenie;
            this.rozmiar = rozmiar;
            this.predkosc = new Vector2(0, 0);
            this.obszarRuchu = new Rectangle(0, 0, 0, 0);
        }

        public Sprite(Texture2D tekstura, Vector2 polozenie, Vector2 rozmiar, Vector2 predkosc, Rectangle obszarRuchu)
            : this(tekstura, polozenie, rozmiar)
        {
            this.predkosc = predkosc;
            this.obszarRuchu = obszarRuchu;
        }

        public bool ZmienPolozenie(float krokCzasowy, TablicaWynikow tablicaWynikow)
        {
            bool czyKolizja = false;
            if (polozenie.X + predkosc.X + rozmiar.X > obszarRuchu.Right)
            {
                polozenie = new Vector2(Game1.szerokosc / 2, Game1.wysokosc / 2);
                predkosc = new Vector2(3, 3);
                tablicaWynikow.DodajPunkt(1);
            }
            if (polozenie.X + predkosc.X < obszarRuchu.Left)
            {
                polozenie = new Vector2(Game1.szerokosc / 2, Game1.wysokosc / 2);
                predkosc = new Vector2(3, 3);
                tablicaWynikow.DodajPunkt(2);
            }
            if (polozenie.Y + predkosc.Y + rozmiar.Y > obszarRuchu.Bottom)
            {
                predkosc.Y = -predkosc.Y;
                czyKolizja = true;
            }
            if (polozenie.Y + predkosc.Y < obszarRuchu.Top)
            {
                predkosc.Y = -predkosc.Y;
                czyKolizja = true;
            }

            polozenie += predkosc * krokCzasowy;

            return czyKolizja;
        }
    }
}

